function [ok]=udp_pwm_command_poke(skt,ofs,data)
%function [ok]=udp_pwm_command_poke(skt,ofs,data)
% Data is a byte vector of bits for the pwm generator
% ls bit is low - so the format is
%   b7    b6    b5    b4    b3    b2    b1    b0
%   pwm7  pwm6  pwm5  pwm4  pwm3  pwm2  pwm1  pwm0
%IP 0.6   0.6   0.4   0.4   0.2   0.2   0.0   0.0
%
%   pwm8  pwm9  pwm10 pwm11 pwm12 pwm13 pwm14 pwm15
%IP 0.14   0.14   0.12  0.12  0.10  0.10  0.8   0.8
%
%   pwm16  pwm17  pwm18 pwm19 NA    NA    NA     NA
%IP 0.16   0.16   0.18  0.18  0.20  0.20  0.22   0.22
% etc.
%
%
%

% ofs of 1 gives first byte in vector
% 26- Aug- 2024 - Ian Stothers


pp_commands;
ok=1;
op=[];

 dptr=0;
 ofs=min([ofs  MAX_SEND_SIZE ]);
 ofs=max([1 ofs]);
 data=bitand(data(:)',255);
 msd=max(size(data));
%truncate length of put to stop over-run
 dend=  min([MAX_SEND_SIZE ofs-1+msd]);
 data=data(1:dend);
 len=max(size(data));

skt.remoteip='1.255';
skt.ip='1.255';
old_to=skt.ser.Timeout;
skt.ser.Timeout=0.0001;


 while (len>0)
      toset=min([len skt.max]);
      cmd=UDP_SEND_VECTOR_FIRE;
      if ((len-toset)>0)
        cmd=UDP_SEND_VECTOR;
      endif
      pbuf=uint8([cmd bitand(toset,255)]);
      pbuf=[pbuf  bitand(ofs-1,255) bitand(floor((ofs-1)/2.^8),255) bitand(floor((ofs-1)/2.^16),255) bitand(floor((ofs-1)/2.^24),255)];
      pbuf=[pbuf  data((1:toset)+dptr)];
      bb=sersendget(skt,pbuf,PPHSIZE);

      dptr=dptr+toset;
      len=len-toset;
      ofs=ofs+toset;
 end %while len
 skt.ser.Timeout=old_to;
endfunction

